<!DOCTYPE html>
<html>

% include('header_intro.tpl', title='Information about the study', parameter = para)


<body>
    <div class="container">
		<h1>About the study</h1>

		<article>
			<p><span class="red">Warning!</span> 
				This study is designed to be interacted with a mouse or keyboard. If you are using a touch device for input you might not be credited the reward!
			</p>

			<h2>Intro</h2> 
			<p>
				This study intends to measure the perception of differences and similarities in the design of lettershapes (fonts). Changing one parameter sometimes influences the perception of other parameters. You will be asked to select three out of fifty fonts that are most similar to a reference font.
			</p>
		</article>

		<article>
			<h2>The trial setup</h2>
            <p>You will be presented fifty randomly selected english words and one reference word on top. Each word is set in a different font. You are asked to select three words that use fonts which are the most similar to the reference font at the top of the words.
			</p>

 			<p>The meaning or combination of the words is irrelevant. They are just used to visualise the lettershapes.</p>

            <p>Select the three words by clicking on them. Each time that you click on a word, its background will change to a darker grey.</p>

            <p>If you are happy with your selection click the <span class='letter_spaced'>OK</span> button below the words or hit the return key on your keyboard. You have to select three and only three words so that the <span class='letter_spaced'>OK</span> button appears at the bottom. Note that you can deselect a word by clicking again on it. After you have clicked the OK button you will be taken to the next trial. Repeat the described procedure until you get to the finish page.</p>

 			<figure>
				<img src="/assets/imgs/info_gifs/select_field.gif" alt="Example of selection.">
				<figcaption>Select three the two lower fonts to the reference on top.</figcaption>
			</figure>

		</article>

		<p>If you are ready to start the study press the <span class='letter_spaced'>START</span> button below.</p><br>
		<p>Please be accurate!</p>
    	<p><form action="./round1"><input type="submit" value="S T A R T"></form></p>

    </div>

    <script>
    	var url_part = { exp: {{!'"%s"' % exp }}, para: {{!'"%s"' % para }} };
    	var para1 = {{!'"%s"' % para1 }};
    	var para2 = {{!'"%s"' % para2 }};
    </script>
    <script src='/assets/js/jquery-1.11.3.min.js'></script>

% include('footer.tpl')

</body>
</html>
